#!/usr/bin/perl
#
$Version = 0.01;
@ARGV = (	"../../release/forums/includes/xml/hooks_ldm.xml",
			"../../release/forums/local_links.php",
			"../../release/forums/local_links_actions.php",
			"../../release/forums/local_links_admin.php",
			"../../release/forums/local_links_ajax.php",
			"../../release/forums/local_links_search.php",
			"../../release/forums/local_resize.php",
			"../../release/extras/rss2/local_links_rss2.php",
			"../../release/forums/local_stream.php",
			"../../release/forums/includes/local_links_include.php",
			"../../release/forums/includes/local_links_misc.php",
			"../../release/forums/includes/local_links_resize.php");

#
# Extracts the hooks from $argv[0] and cross-references against hooks in all other arguments
#
# Usage : hooksval.pl
#

$xml = shift @ARGV;
open XML , "<$xml" or die "Unable to open $xml";

$hooklist = "";
while (<XML>) { $hooklist .= $_; }
close XML;

%set_hooks = ();
while ($hooklist =~ m/<hook>(.*?)</gs) {
    $set_hooks{$1} = 0;
}

while ($file = shift @ARGV) {
    print $file."\n";
    open FILE , "<$file" or die "Unable to open $file";
    $hooklist = "";
    while (<FILE>) { $hooklist .= $_; }
    close FILE;
    while ($hooklist =~ m/vBulletinHook::fetch_hook..(.*?)'\)/gs) {
        if (exists $set_hooks{$1}) {
            $set_hooks{$1}++;
        }
        else {
            print "Unrecognised: ".$1."\n";
        }
    }
}

print "\n\n";
foreach $k (sort keys %set_hooks) {
    printf "%3d %s\n" , $set_hooks{$k}, $k;
}

